//this file is part of Silversurfer
//Copyright (C)2006-2008 dlarge ( http://sourceforge.net/projects/silversurfer)
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#pragma once

#include "opcodes.h"

////////////////////////////////////////////////
// Limits & Defaults
////////////////////////////////////////////////

////////////////////////////////////////////////
// Calculation defines
////////////////////////////////////////////////

#define	MS2SEC(ms)		((ms)/1000)
#define	MS2MIN(ms)		MS2SEC((ms)/60)
#define	MS2HR(ms)		MS2MIN((ms)/60)
#define	KB2BYTE(kb)		((kb)*1024)
#define	BYTE2KB(byte)	((byte)/1024)

////////////////////////////////////////////////
// Preferences defines
////////////////////////////////////////////////

//==> dlarge Argos System (Xanatos)
#define TIM_ARGOS_TRUST_TIME_MIN		240
#define TIM_ARGOS_TRUST_TIME_DEF		360
#define TIM_ARGOS_TRUST_TIME_MAX		480

#define TIM_ARGOS_BAN_TIME_MIN			30
#define TIM_ARGOS_BAN_TIME_DEF			60
#define TIM_ARGOS_BAN_TIME_MAX			180

#define TIM_ARGOS_TRACK_TIME_MIN		60
#define TIM_ARGOS_TRACK_TIME_DEF		120
#define TIM_ARGOS_TRACK_TIME_MAX		720

#define TIM_ARGOS_GENERIC_BAN_TIME_MIN	60
#define TIM_ARGOS_GENERIC_BAN_TIME_DEF	120
#define TIM_ARGOS_GENERIC_BAN_TIME_MAX	240

#define TIM_ARGOS_BAN_BAD_TIME_MIN		60
#define TIM_ARGOS_BAN_TIME_CORRUPT_DEF	180
#define TIM_ARGOS_BAN_TIME_SCANNER_DEF	120
#define	TIM_ARGOS_BAN_TIME_FAILED_DEF	240
#define TIM_ARGOS_BAN_BAD_TIME_MAX		720

#define TIM_ARGOS_AGRESSION_INTERVALS_MIN	1
#define TIM_ARGOS_AGRESSION_INTERVALS_DEF	10
#define TIM_ARGOS_AGRESSION_INTERVALS_MAX	15

#define VAL_ARGOS_AGRESSION_THRESHOLD_MIN	2
#define VAL_ARGOS_AGRESSION_THRESHOLD_DEF	3
#define VAL_ARGOS_AGRESSION_THRESHOLD_MAX	5

#define VAL_ARGOS_FAILED_TRIES_MIN		2
#define VAL_ARGOS_FAILED_TRIES_DEF		3
#define VAL_ARGOS_FAILED_TRIES_MAX		5

#define VAL_ARGOS_FAILED_THRESHOLD_MIN	1
#define VAL_ARGOS_FAILED_THRESHOLD_DEF	12
#define VAL_ARGOS_FAILED_THRESHOLD_MAX	20

#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MIN	10
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_DEF	30
#define TIM_ARGOS_XS_EXPLOIT_INTERVALS_MAX	30

#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MIN	2
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_DEF	3
#define VAL_ARGOS_XS_EXPLOIT_THRESHOLD_MAX	5

#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MIN	60
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_DEF	180
#define TIM_ARGOS_NICK_CHANGE_INTERVALS_MAX	180

#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_DEF	3
#define VAL_ARGOS_NICK_CHANGE_THRESHOLD_MAX	5

#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MIN	30
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_DEF	60
#define TIM_ARGOS_MOD_CHANGE_INTERVALS_MAX	90

#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MIN	2
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_DEF	4
#define VAL_ARGOS_MOD_CHANGE_THRESHOLD_MAX	5

//<== dlarge Argos System (Xanatos)

//==> dlarge ReleaseBonus (X-Ray)
#define VAL_RELBONUS_MIN	0
#define VAL_RELBONUS_DEF	0
#define VAL_RELBONUS_MAX	32
//<== dlarge ReleaseBonus (X-Ray)

// TODOSILVERSURFER: Add Defaults and Limits of other features